/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DisasterRadiusEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature your opponents control");

    public DisasterRadiusEffect() {
        super(Outcome.GainLife);
        this.staticText = "{this} deals X damage to each creature your opponents control, where X is the revealed card's mana value";
    }

    private DisasterRadiusEffect(DisasterRadiusEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = (RevealTargetFromHandCost)source.getCosts().get(0);
        if (cost != null) {
            int damage = cost.manaValues;
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                if (creature == null) continue;
                creature.damage(damage, source.getSourceId(), source, game, false, false);
            }
            return true;
        }
        return false;
    }

    public DisasterRadiusEffect copy() {
        return new DisasterRadiusEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

