/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class DiscipleOfBolasEffect
extends OneShotEffect {
    DiscipleOfBolasEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice another creature. You gain X life and draw X cards, where X is that creature's power";
    }

    private DiscipleOfBolasEffect(DiscipleOfBolasEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiscipleOfBolasEffect copy() {
        return new DiscipleOfBolasEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE);
        if (!cost.canPay(source, source, source.getControllerId(), game) || !cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        int power = cost.getPermanents().stream().map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        if (power > 0) {
            controller.gainLife(power, game, source);
            controller.drawCards(power, source, game);
        }
        return true;
    }
}

