/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class DisciplesOfGixEffect
extends OneShotEffect {
    DisciplesOfGixEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to three artifact cards, put them into your graveyard, then shuffle";
    }

    private DisciplesOfGixEffect(DisciplesOfGixEffect effect) {
        super((OneShotEffect)effect);
    }

    public DisciplesOfGixEffect copy() {
        return new DisciplesOfGixEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 3, (FilterCard)StaticFilters.FILTER_CARD_ARTIFACT);
        controller.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

