/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class DiscordantSpiritWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    DiscordantSpiritWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER) {
            this.map.compute(event.getTargetId(), (u, i) -> i == null ? event.getAmount() : Integer.sum(i, event.getAmount()));
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static int getCount(Game game, Ability source) {
        return ((DiscordantSpiritWatcher)game.getState().getWatcher(DiscordantSpiritWatcher.class)).map.getOrDefault(source.getControllerId(), 0);
    }
}

