/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;

class DisorientingChoiceEffect
extends OneShotEffect {
    DisorientingChoiceEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each opponent, choose up to one target artifact or enchantment that player controls. For each permanent chosen this way, its controller may exile it. Then if one or more of the chosen permanents are still on the battlefield, you search your library for up to that many land cards, put them onto the battlefield tapped, then shuffle.";
    }

    private DisorientingChoiceEffect(DisorientingChoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public DisorientingChoiceEffect copy() {
        return new DisorientingChoiceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInLibrary target;
        Player controller = game.getPlayer(source.getControllerId());
        CardsImpl permanentsToExile = new CardsImpl();
        int numberOfLandsToFetch = 0;
        if (controller == null) {
            return false;
        }
        List permanents = source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Permanent permanent : permanents) {
            Player player = game.getPlayer(permanent.getControllerId());
            if (player == null) continue;
            if (player.chooseUse(this.outcome, "Exile " + permanent.getLogName() + "? If you don't, " + controller.getName() + " will get a land from their library.", source, game)) {
                game.informPlayers(player.getLogName() + " chose to have their " + permanent.getLogName() + " exiled.");
                permanentsToExile.add((Card)permanent);
                continue;
            }
            game.informPlayers(player.getLogName() + " chose to have " + controller.getName() + " get a land.");
            ++numberOfLandsToFetch;
        }
        controller.moveCards((Cards)permanentsToExile, Zone.EXILED, source, game);
        if (numberOfLandsToFetch > 0 && controller.searchLibrary(target = new TargetCardInLibrary(0, numberOfLandsToFetch, (FilterCard)new FilterLandCard()), source, game)) {
            for (UUID cardId : target.getTargets()) {
                Card card = game.getCard(cardId);
                if (card == null) continue;
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
        }
        return true;
    }
}

