/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.condition.common.MetalcraftCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;

class DispenseJusticeEffect
extends OneShotEffect {
    private static final String effectText = "Target player sacrifices an attacking creature.<br><i>Metalcraft</i> &mdash; That player sacrifices two attacking creatures instead if you control three or more artifacts";
    private static final FilterAttackingCreature filter = new FilterAttackingCreature();

    DispenseJusticeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = effectText;
    }

    private DispenseJusticeEffect(DispenseJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        if (MetalcraftCondition.instance.apply(game, source)) {
            return new SacrificeEffect((FilterPermanent)filter, 2, effectText).apply(game, source);
        }
        return new SacrificeEffect((FilterPermanent)filter, 1, effectText).apply(game, source);
    }

    public DispenseJusticeEffect copy() {
        return new DispenseJusticeEffect(this);
    }
}

