/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class DistantMelodyEffect
extends OneShotEffect {
    DistantMelodyEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Choose a creature type. Draw a card for each permanent you control of that type";
    }

    private DistantMelodyEffect(DistantMelodyEffect effect) {
        super((OneShotEffect)effect);
    }

    public DistantMelodyEffect copy() {
        return new DistantMelodyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (controller != null && controller.choose(Outcome.BoostCreature, (Choice)typeChoice, game)) {
            FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
            filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            return new DrawCardSourceControllerEffect((DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)filter)).apply(game, source);
        }
        return false;
    }
}

