/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.ManaUtil;

class DivertEffect
extends OneShotEffect {
    DivertEffect() {
        super(Outcome.Detriment);
        this.staticText = "Change the target of target spell with a single target unless that spell's controller pays {2}.";
    }

    private DivertEffect(DivertEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivertEffect copy() {
        return new DivertEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        ManaCost cost = ManaUtil.createManaCost((int)2, (boolean)false);
        if (spell != null && (player = game.getPlayer(spell.getControllerId())) != null && !cost.pay(source, game, source, spell.getControllerId(), false, null)) {
            return spell.chooseNewTargets(game, source.getControllerId(), true, true, null);
        }
        return false;
    }
}

