/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class DivineReckoningEffect
extends OneShotEffect {
    DivineReckoningEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player chooses a creature they control. Destroy the rest";
    }

    private DivineReckoningEffect(DivineReckoningEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> chosen = new ArrayList<Permanent>();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Permanent permanent;
                TargetControlledPermanent target;
                Player player = game.getPlayer(playerId);
                if (player == null || !player.chooseTarget(Outcome.Benefit, (Target)(target = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledCreaturePermanent(), true)), source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null) continue;
                chosen.add(permanent);
            }
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game)) {
                if (chosen.contains(permanent)) continue;
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    public DivineReckoningEffect copy() {
        return new DivineReckoningEffect(this);
    }
}

