/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DrawCardControllerTriggeredAbility;
import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.EquipAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SetTargetPointer;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;

public final class DivinersWand
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent(SubType.WIZARD, "a Wizard creature");

    public DivinersWand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.KINDRED, CardType.ARTIFACT}, "{3}");
        this.subtype.add((Object)SubType.WIZARD);
        this.subtype.add((Object)SubType.EQUIPMENT);
        DrawCardControllerTriggeredAbility newBoost = new DrawCardControllerTriggeredAbility((Effect)new BoostSourceEffect(1, 1, Duration.EndOfTurn), false);
        newBoost.addEffect(new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn).concatBy("and"));
        SimpleActivatedAbility newDraw = new SimpleActivatedAbility((Effect)new DrawCardSourceControllerEffect(1), (Cost)new GenericManaCost(4));
        ContinuousEffect effectBoost = new GainAbilityAttachedEffect((Ability)newBoost, AttachmentType.EQUIPMENT).setText("Equipped creature has \"Whenever you draw a card, this creature gets +1/+1 and gains flying until end of turn\"");
        ContinuousEffect effectDraw = new GainAbilityAttachedEffect((Ability)newDraw, AttachmentType.EQUIPMENT).setText("\"{4}: Draw a card.\"");
        SimpleStaticAbility totalAbility = new SimpleStaticAbility((Effect)effectBoost);
        totalAbility.addEffect(effectDraw.concatBy("and"));
        this.addAbility((Ability)totalAbility);
        this.addAbility((Ability)new EntersBattlefieldAllTriggeredAbility(Zone.BATTLEFIELD, (Effect)new AttachEffect(Outcome.Detriment, "attach {this} to it"), filter, true, SetTargetPointer.PERMANENT));
        this.addAbility((Ability)new EquipAbility(Outcome.AddAbility, (Cost)new GenericManaCost(3), false));
    }

    private DivinersWand(DivinersWand card) {
        super((CardImpl)card);
    }

    public DivinersWand copy() {
        return new DivinersWand(this);
    }
}

