/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DollhouseOfHorrorsEffect
extends OneShotEffect {
    private static final DynamicValue xValue = new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledPermanent(SubType.CONSTRUCT));

    DollhouseOfHorrorsEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of the exiled card, except it's a 0/0 Construct artifact in addition to its other types and it has \"This creature gets +1/+1 for each Construct you control.\" It gains haste until end of turn";
    }

    private DollhouseOfHorrorsEffect(DollhouseOfHorrorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DollhouseOfHorrorsEffect copy() {
        return new DollhouseOfHorrorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), CardType.ARTIFACT, false, 1, false, false, null, 0, 0, false);
        effect.setSavedPermanent((Permanent)new PermanentCard(CardUtil.getDefaultCardSideForBattlefield((Game)game, (Card)card), source.getControllerId(), game));
        effect.withAdditionalSubType(SubType.CONSTRUCT);
        effect.addAdditionalAbilities(new Ability[]{new SimpleStaticAbility((Effect)new BoostSourceEffect(xValue, xValue, Duration.WhileOnBattlefield, "this creature"))});
        effect.apply(game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game)), source);
        return true;
    }
}

