/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DomriRadeEffect1
extends OneShotEffect {
    public DomriRadeEffect1() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top card of your library. If it's a creature card, you may reveal it and put it into your hand";
    }

    private DomriRadeEffect1(DomriRadeEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public DomriRadeEffect1 copy() {
        return new DomriRadeEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && controller != null && controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl();
            cards.add(card);
            controller.lookAtCards(sourceObject.getName(), (Cards)cards, game);
            if (card.isCreature(game) && controller.chooseUse(this.outcome, "Reveal " + card.getName() + " and put it into your hand?", source, game)) {
                controller.moveCards(card, Zone.HAND, source, game);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            }
            return true;
        }
        return false;
    }
}

