/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class DonnaNobleTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    DonnaNobleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)SavedDamageValue.MUCH));
        this.addTarget((Target)new TargetOpponent());
        this.setTriggerPhrase("Whenever {this} or a creature it's paired with is dealt damage, ");
    }

    private DonnaNobleTriggeredAbility(DonnaNobleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DonnaNobleTriggeredAbility copy() {
        return new DonnaNobleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int damage;
        if (!CardUtil.getEventTargets((GameEvent)event).contains(this.getSourceId())) {
            Permanent paired;
            Permanent permanent = game.getPermanent(this.getSourceId());
            if (permanent != null && permanent.getPairedCard() != null) {
                paired = permanent.getPairedCard().getPermanent(game);
                if (paired == null || paired.getPairedCard() == null || !paired.getPairedCard().equals((Object)new MageObjectReference((MageObject)permanent, game))) {
                    return false;
                }
            } else {
                return false;
            }
            if (!CardUtil.getEventTargets((GameEvent)event).contains(paired.getId())) {
                return false;
            }
        }
        if ((damage = event.getAmount()) < 1) {
            return false;
        }
        this.getEffects().setValue("damage", (Object)damage);
        return true;
    }
}

