/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.KnightToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class DoomForetoldEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent("nonland, nontoken permanent");
    private static final Effect effect1;
    private static final Effect effect2;

    DoomForetoldEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player sacrifices a nonland, nontoken permanent. If that player can't, they discard a card, they lose 2 life, you draw a card, you gain 2 life, you create a 2/2 white Knight creature token with vigilance, then you sacrifice {this}";
    }

    private DoomForetoldEffect(DoomForetoldEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoomForetoldEffect copy() {
        return new DoomForetoldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(game.getActivePlayerId());
        if (controller == null || player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(filter);
        if (target.canChoose(player.getId(), source, game) && player.choose(Outcome.Sacrifice, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null && permanent.sacrifice(source, game)) {
            return true;
        }
        player.discard(1, false, false, source, game);
        player.loseLife(2, game, source, false);
        controller.drawCards(1, source, game);
        controller.gainLife(2, game, source);
        effect1.apply(game, source);
        effect2.apply(game, source);
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
        effect1 = new CreateTokenEffect((Token)new KnightToken());
        effect2 = new SacrificeSourceEffect();
    }
}

