/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DoorsOfDurinEffect
extends OneShotEffect {
    private static final FilterPermanent filter1 = new FilterControlledPermanent(SubType.DWARF);
    private static final FilterPermanent filter2 = new FilterControlledPermanent(SubType.ELF);

    DoorsOfDurinEffect() {
        super(Outcome.Benefit);
        this.staticText = "scry 2, then you may reveal the top card of your library. If it's a creature card, put it onto the battlefield tapped and attacking. Until your next turn, it gains trample if you control a Dwarf and hexproof if you control an Elf";
    }

    private DoorsOfDurinEffect(DoorsOfDurinEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoorsOfDurinEffect copy() {
        return new DoorsOfDurinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.scry(2, source, game);
        Card card = player.getLibrary().getFromTop(game);
        if (card == null || !player.chooseUse(this.outcome, "Reveal " + card.getIdName() + '?', source, game)) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (!card.isCreature(game)) {
            return true;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return true;
        }
        game.getCombat().addAttackingCreature(permanent.getId(), game);
        if (game.getBattlefield().contains(filter1, source, game, 1)) {
            game.addEffect(new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.UntilYourNextTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        if (game.getBattlefield().contains(filter2, source, game, 1)) {
            game.addEffect(new GainAbilityTargetEffect((Ability)HexproofAbility.getInstance(), Duration.UntilYourNextTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

