/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class DragonCultistWatcher
extends Watcher {
    private final Map<UUID, Map<MageObjectReference, Integer>> map = new HashMap<UUID, Map<MageObjectReference, Integer>>();

    DragonCultistWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.DAMAGED_PLAYER) {
            Integer amount = event.getAmount();
            this.map.computeIfAbsent(game.getControllerId(event.getSourceId()), x -> new HashMap()).compute(new MageObjectReference(event.getSourceId(), game), (k, v) -> v == null ? amount : v + amount);
        }
    }

    public void reset() {
        this.map.clear();
        super.reset();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((DragonCultistWatcher)game.getState().getWatcher(DragonCultistWatcher.class)).map.getOrDefault(playerId, Collections.emptyMap()).values().stream().anyMatch(x -> x >= 5);
    }
}

