/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.FerociousCondition;
import mage.abilities.decorator.ConditionalAsThoughEffect;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.CastAsThoughItHadFlashSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.common.FerociousHint;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class DragonGrip
extends CardImpl {
    public DragonGrip(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{R}");
        this.subtype.add((Object)SubType.AURA);
        CastAsThoughItHadFlashSourceEffect effect = new CastAsThoughItHadFlashSourceEffect(Duration.EndOfGame);
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new ConditionalAsThoughEffect((AsThoughEffect)effect, (Condition)FerociousCondition.instance).setText("<i>Ferocious</i> &mdash; If you control a creature with power 4 or greater, you may cast this spell as though it had flash")).addHint((Hint)FerociousHint.instance));
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        BoostEnchantedEffect effect2 = new BoostEnchantedEffect(2, 0, Duration.WhileOnBattlefield);
        effect2.setText("Enchanted creature gets +2/+0");
        ability = new SimpleStaticAbility((Effect)effect2);
        effect2 = new GainAbilityAttachedEffect((Ability)FirstStrikeAbility.getInstance(), AttachmentType.AURA);
        effect2.setText("and has first strike");
        ability.addEffect((Effect)effect2);
        this.addAbility((Ability)ability);
    }

    private DragonGrip(DragonGrip card) {
        super((CardImpl)card);
    }

    public DragonGrip copy() {
        return new DragonGrip(this);
    }
}

