/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInHand;

class DragonsFireCost
extends CostImpl {
    private DragonZone dragonZone = null;
    private UUID selectedCardId = null;
    private static final FilterCard handFilter = new FilterCard("Dragon card from your hand");
    private static final FilterControlledPermanent battlefieldFilter = new FilterControlledPermanent(SubType.DRAGON);

    public DragonsFireCost() {
        this.text = "you may reveal a Dragon card from your hand or choose a Dragon you control";
    }

    private DragonsFireCost(DragonsFireCost cost) {
        super((CostImpl)cost);
        this.dragonZone = cost.dragonZone;
        this.selectedCardId = cost.selectedCardId;
    }

    public DragonsFireCost copy() {
        return new DragonsFireCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        this.dragonZone = null;
        this.selectedCardId = null;
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            boolean dragonInHand = false;
            boolean dragonOnBattlefield = false;
            Enum chosenZone = null;
            for (UUID cardId : controller.getHand()) {
                Card card = game.getCard(cardId);
                if (card == null || !card.hasSubtype(SubType.DRAGON, game)) continue;
                dragonInHand = true;
                break;
            }
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(controllerId)) {
                if (permanent == null || !permanent.hasSubtype(SubType.DRAGON, game)) continue;
                dragonOnBattlefield = true;
                break;
            }
            if (dragonInHand && dragonOnBattlefield) {
                if (controller.chooseUse(Outcome.Benefit, "Reveal a Dragon card from your hand or choose a Dragon you control?", source, game)) {
                    chosenZone = controller.chooseUse(Outcome.Benefit, "Choose Dragon from hand or Dragon on battlefield", null, "Hand", "Battlefield", source, game) ? DragonZone.HAND : DragonZone.BATTLEFIELD;
                }
            } else if (dragonInHand) {
                if (controller.chooseUse(Outcome.Benefit, "Reveal a Dragon card from your hand?", source, game)) {
                    chosenZone = DragonZone.HAND;
                }
            } else if (dragonOnBattlefield && controller.chooseUse(Outcome.Benefit, "Choose a dragon on the battlefield?", source, game)) {
                chosenZone = DragonZone.BATTLEFIELD;
            }
            switch (1.$SwitchMap$mage$cards$d$DragonsFireCost$DragonZone[chosenZone.ordinal()]) {
                case 1: {
                    Card card;
                    TargetCardInHand handTarget = new TargetCardInHand(handFilter);
                    handTarget.withNotTarget(true);
                    if (!controller.choose(Outcome.Benefit, (Target)handTarget, source, game) || (card = game.getCard(handTarget.getFirstTarget())) == null) break;
                    this.dragonZone = DragonZone.HAND;
                    this.selectedCardId = handTarget.getFirstTarget();
                    controller.revealCards(source, (Cards)new CardsImpl(card), game);
                    break;
                }
                case 2: {
                    Permanent permanent;
                    TargetPermanent battlefieldTarget = new TargetPermanent((FilterPermanent)battlefieldFilter);
                    battlefieldTarget.withNotTarget(true);
                    if (!controller.choose(Outcome.Benefit, (Target)battlefieldTarget, source, game) || (permanent = game.getPermanent(battlefieldTarget.getFirstTarget())) == null) break;
                    this.dragonZone = DragonZone.BATTLEFIELD;
                    this.selectedCardId = battlefieldTarget.getFirstTarget();
                    game.informPlayers(controller.getLogName() + " chooses " + permanent.getLogName());
                }
            }
        }
        this.paid = true;
        return true;
    }

    public DragonZone getDragonZone() {
        return this.dragonZone;
    }

    public UUID getSelectedCardId() {
        return this.selectedCardId;
    }

    static {
        handFilter.add((Predicate)SubType.DRAGON.getPredicate());
    }

    public static enum DragonZone {
        HAND,
        BATTLEFIELD;

    }
}

