/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

class DranaAndLinvalaManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    DranaAndLinvalaManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may spend mana as though it were mana of any color to activate those abilities";
    }

    private DranaAndLinvalaManaEffect(DranaAndLinvalaManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public DranaAndLinvalaManaEffect copy() {
        return new DranaAndLinvalaManaEffect(this);
    }

    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        return CardUtil.getMainCardId((Game)game, (UUID)objectId).equals(source.getSourceId()) && CardUtil.getEffectValueFromAbility((Ability)affectedAbility, (String)"dranaLinvalaFlag", Boolean.class).orElse(false) != false && source.isControlledBy(playerId);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        return false;
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

