/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.d.DranaTheLastBloodchiefCounterEffect;
import mage.cards.d.DranaTheLastBloodchiefSubtypeEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class DranaTheLastBloodchiefEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("nonlegendary creature card");

    DranaTheLastBloodchiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player chooses a nonlegendary creature card in your graveyard. You return that card to the battlefield with an additional +1/+1 counter on it. The creature is a Vampire in addition to its other types.";
    }

    private DranaTheLastBloodchiefEffect(DranaTheLastBloodchiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public DranaTheLastBloodchiefEffect copy() {
        return new DranaTheLastBloodchiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null || controller.getGraveyard().count(filter, game) < 1) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Cards)controller.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new DranaTheLastBloodchiefSubtypeEffect(card, game), source);
        game.addEffect((ContinuousEffect)new DranaTheLastBloodchiefCounterEffect(card, game), source);
        return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
    }
}

