/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCreatureTypeAdditionEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DreadSlaverEffect
extends OneShotEffect {
    DreadSlaverEffect() {
        super(Outcome.Benefit);
        this.staticText = "return it to the battlefield under your control. That creature is a black Zombie in addition to its other colors and types";
    }

    private DreadSlaverEffect(DreadSlaverEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreadSlaverEffect copy() {
        return new DreadSlaverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null) {
            return false;
        }
        if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent != null) {
                AddCreatureTypeAdditionEffect effect = new AddCreatureTypeAdditionEffect(SubType.ZOMBIE, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

