/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.decorator.ConditionalContinuousRuleModifyingEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousRuleModifyingEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.cards.d.DreadWightCounterCondition;
import mage.cards.d.DreadWightDoNotUntapEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DreadWightEffect
extends OneShotEffect {
    String rule = "doesn't untap during its controller's untap step for as long as it has a paralyzation counter on it.";

    public DreadWightEffect() {
        super(Outcome.Detriment);
        this.staticText = "put a paralyzation counter on each creature blocking or blocked by {this} and tap those creatures. Each of those creatures doesn't untap during its controller's untap step for as long as it has a paralyzation counter on it. Each of those creatures gains \"{4}: Remove a paralyzation counter from this creature.\"";
    }

    private DreadWightEffect(DreadWightEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreadWightEffect copy() {
        return new DreadWightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.PARALYZATION.createInstance());
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
            permanent.tap(source, game);
            DreadWightDoNotUntapEffect effect2 = new DreadWightDoNotUntapEffect(Duration.WhileOnBattlefield, permanent.getId());
            effect2.setText("This creature doesn't untap during its controller's untap step for as long as it has a paralyzation counter on it");
            DreadWightCounterCondition condition = new DreadWightCounterCondition(permanent.getId());
            ConditionalContinuousRuleModifyingEffect conditionalEffect = new ConditionalContinuousRuleModifyingEffect((ContinuousRuleModifyingEffect)effect2, (Condition)condition);
            SimpleStaticAbility ability = new SimpleStaticAbility(Zone.BATTLEFIELD, (Effect)conditionalEffect);
            GainAbilityTargetEffect effect3 = new GainAbilityTargetEffect((Ability)ability, Duration.WhileOnBattlefield);
            ability.setRuleVisible(true);
            effect3.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect3, source);
            SimpleActivatedAbility activatedAbility = new SimpleActivatedAbility(Zone.BATTLEFIELD, (Effect)new RemoveCounterSourceEffect(CounterType.PARALYZATION.createInstance()), (Cost)new ManaCostsImpl("{4}"));
            GainAbilityTargetEffect effect4 = new GainAbilityTargetEffect((Ability)activatedAbility, Duration.WhileOnBattlefield);
            effect4.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect4, source);
            return true;
        }
        return false;
    }
}

