/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.AttacksAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.SetTargetPointer;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.permanent.TokenPredicate;

public final class DreadhordeInvasion
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent(SubType.ZOMBIE, "Zombie token you control with power 6 or greater");

    public DreadhordeInvasion(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{B}");
        BeginningOfUpkeepTriggeredAbility ability = new BeginningOfUpkeepTriggeredAbility((Effect)new LoseLifeSourceControllerEffect(1));
        ability.addEffect((Effect)new AmassEffect(1, SubType.ZOMBIE).concatBy("and"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new AttacksAllTriggeredAbility((Effect)new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn, "it gains lifelink until end of turn"), false, filter, SetTargetPointer.PERMANENT, false));
    }

    private DreadhordeInvasion(DreadhordeInvasion card) {
        super((CardImpl)card);
    }

    public DreadhordeInvasion copy() {
        return new DreadhordeInvasion(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 5));
        filter.add((Predicate)TokenPredicate.TRUE);
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

