/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class DreamPillagerEffect
extends OneShotEffect {
    DreamPillagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile that many cards from the top of your library. Until end of turn, you may cast spells from among those exiled cards";
    }

    private DreamPillagerEffect(DreamPillagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreamPillagerEffect copy() {
        return new DreamPillagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            int amount = (Integer)this.getValue("damage");
            if (amount > 0) {
                Set cards = controller.getLibrary().getTopCards(game, amount);
                if (!cards.isEmpty()) {
                    controller.moveCards(cards, Zone.EXILED, source, game);
                    CardsImpl canBeCast = new CardsImpl();
                    for (Card card : cards) {
                        if (card.isLand(game)) continue;
                        canBeCast.add(card);
                    }
                    PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)canBeCast, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
                return true;
            }
            return true;
        }
        return false;
    }
}

