/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.events.ZoneChangeEvent;

class DrivnodCarnageDominusEffect
extends ReplacementEffectImpl {
    DrivnodCarnageDominusEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature dying causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time.";
    }

    private DrivnodCarnageDominusEffect(DrivnodCarnageDominusEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DrivnodCarnageDominusEffect copy() {
        return new DrivnodCarnageDominusEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event instanceof NumberOfTriggersEvent) {
            NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
            if (source.isControlledBy(event.getPlayerId()) && game.getPermanentOrLKIBattlefield(numberOfTriggersEvent.getSourceId()) != null && numberOfTriggersEvent.getSourceEvent() instanceof ZoneChangeEvent) {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)numberOfTriggersEvent.getSourceEvent();
                return zEvent.isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isCreature(game);
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

