/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DualNatureCreatureLeavesEffect
extends OneShotEffect {
    DualNatureCreatureLeavesEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "exile all tokens with the same name as that creature";
    }

    private DualNatureCreatureLeavesEffect(DualNatureCreatureLeavesEffect effect) {
        super((OneShotEffect)effect);
    }

    public DualNatureCreatureLeavesEffect copy() {
        return new DualNatureCreatureLeavesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (creature != null) {
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)TokenPredicate.TRUE);
            filter.add((Predicate)new NamePredicate(creature.getName()));
            new ExileAllEffect(filter).apply(game, source);
            return true;
        }
        return false;
    }
}

