/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DualNatureExileEffect
extends OneShotEffect {
    private String cardZoneString;

    DualNatureExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all tokens created with {this}.";
    }

    private DualNatureExileEffect(DualNatureExileEffect effect) {
        super((OneShotEffect)effect);
        this.cardZoneString = effect.cardZoneString;
    }

    public DualNatureExileEffect copy() {
        return new DualNatureExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object object = game.getState().getValue(this.cardZoneString);
        if (object != null) {
            Set tokensCreated = (Set)object;
            for (UUID tokenId : tokensCreated) {
                Permanent token = game.getPermanent(tokenId);
                if (token == null) continue;
                token.destroy(source, game, true);
            }
        }
        return true;
    }

    public void setCardZoneString(String cardZoneString) {
        this.cardZoneString = cardZoneString;
    }
}

