/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterOwnedCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DuneChanterContinuousEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filterPermanent = StaticFilters.FILTER_CONTROLLED_PERMANENT_LANDS;
    private static final FilterOwnedCard filterCard = new FilterOwnedCard("land cards you own that aren't on the battlefield");
    private static final SubType subType = SubType.DESERT;

    public DuneChanterContinuousEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Lands you control and land cards you own that aren't on the battlefield are Deserts in addition to their other types";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
    }

    private DuneChanterContinuousEffect(DuneChanterContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DuneChanterContinuousEffect copy() {
        return new DuneChanterContinuousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        for (UUID cardId : controller.getGraveyard()) {
            card = game.getCard(cardId);
            if (!filterCard.match(card, controllerId, source, game) || card.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute((MageObject)card, game).getSubtype().add((Object)subType);
        }
        for (UUID cardId : controller.getHand()) {
            card = game.getCard(cardId);
            if (!filterCard.match(card, controllerId, source, game) || card.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute((MageObject)card, game).getSubtype().add((Object)subType);
        }
        for (Card card2 : game.getState().getExile().getCardsOwned(game, controllerId)) {
            if (!filterCard.match(card2, controllerId, source, game) || card2.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute((MageObject)card2, game).getSubtype().add((Object)subType);
        }
        for (Card card2 : controller.getLibrary().getCards(game)) {
            if (!filterCard.match(card2, controllerId, source, game) || card2.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute((MageObject)card2, game).getSubtype().add((Object)subType);
        }
        List lands = game.getBattlefield().getAllActivePermanents(filterPermanent, controllerId, game);
        for (Permanent land : lands) {
            if (land == null) continue;
            land.addSubType(game, new SubType[]{subType});
        }
        return true;
    }

    static {
        filterCard.add((Predicate)CardType.LAND.getPredicate());
    }
}

