/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DurkwoodTrackerEffect
extends OneShotEffect {
    DurkwoodTrackerEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is on the battlefield, it deals damage equal to its power to target attacking creature. That creature deals damage equal to its power to {this}";
    }

    private DurkwoodTrackerEffect(DurkwoodTrackerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DurkwoodTrackerEffect copy() {
        return new DurkwoodTrackerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || permanent.getZoneChangeCounter(game) != source.getStackMomentSourceZCC()) {
            return false;
        }
        Permanent targeted = game.getPermanent(source.getFirstTarget());
        if (targeted == null) {
            return false;
        }
        targeted.damage(permanent.getPower().getValue(), permanent.getId(), source, game, false, true);
        permanent.damage(targeted.getPower().getValue(), targeted.getId(), source, game, false, true);
        return true;
    }
}

