/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class DwarvenShrineEffect
extends OneShotEffect {
    DwarvenShrineEffect() {
        super(Outcome.Detriment);
        this.staticText = "Whenever a player casts a spell, {this} deals X damage to that player, where X is twice the number of cards in all graveyards with the same name as that spell.";
    }

    private DwarvenShrineEffect(DwarvenShrineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Spell spell;
        int count = 0;
        MageObject mageObject = game.getObject(source);
        if (mageObject != null && (spell = (Spell)game.getState().getValue("dwarvenShrine" + mageObject)) != null && (controller = game.getPlayer(spell.getControllerId())) != null) {
            String name = spell.getName();
            FilterCard filterCardName = new FilterCard();
            filterCardName.add((Predicate)new NamePredicate(name));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                count += player.getGraveyard().count(filterCardName, game);
            }
            controller.damage(count * 2, mageObject.getId(), source, game);
            return true;
        }
        return false;
    }

    public DwarvenShrineEffect copy() {
        return new DwarvenShrineEffect(this);
    }
}

