/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.ManaPaidSourceWatcher;

class DynaheirInvokerAdeptTriggeredAbility
extends DelayedTriggeredAbility {
    DynaheirInvokerAdeptTriggeredAbility() {
        super((Effect)new CopyStackObjectEffect(), Duration.EndOfTurn, true);
        this.setTriggerPhrase("When you next activate an ability that isn't a mana ability this turn by spending four or more mana to activate it, ");
    }

    private DynaheirInvokerAdeptTriggeredAbility(DynaheirInvokerAdeptTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public DynaheirInvokerAdeptTriggeredAbility copy() {
        return new DynaheirInvokerAdeptTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
        if (stackAbility == null || stackAbility.getStackAbility().isManaActivatedAbility() || ManaPaidSourceWatcher.getTotalPaid((UUID)stackAbility.getId(), (Game)game) < 4) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }
}

