/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NoMoreThanOneCreatureCanBlockEachTurnEffect
extends RestrictionEffect {
    NoMoreThanOneCreatureCanBlockEachTurnEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "No more than one creature can block each combat";
    }

    private NoMoreThanOneCreatureCanBlockEachTurnEffect(NoMoreThanOneCreatureCanBlockEachTurnEffect effect) {
        super((RestrictionEffect)effect);
    }

    public NoMoreThanOneCreatureCanBlockEachTurnEffect copy() {
        return new NoMoreThanOneCreatureCanBlockEachTurnEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent != null && permanent.isCreature(game);
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        for (UUID creatureId : game.getCombat().getBlockers()) {
            Permanent existingBlocker = game.getPermanent(creatureId);
            if (!game.getPlayer(existingBlocker.getControllerId()).hasOpponent(attacker.getControllerId(), game) || !existingBlocker.isControlledBy(blocker.getControllerId())) continue;
            return false;
        }
        return true;
    }
}

