/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UnboostCreaturesDefendingPlayerEffect
extends ContinuousEffectImpl {
    UnboostCreaturesDefendingPlayerEffect() {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.UnboostCreature);
        this.staticText = "creatures defending player controls get -1/-1 until end of turn for each +1/+1 counter on Darth Vader";
    }

    private UnboostCreaturesDefendingPlayerEffect(UnboostCreaturesDefendingPlayerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public UnboostCreaturesDefendingPlayerEffect copy() {
        return new UnboostCreaturesDefendingPlayerEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, this.getTargetPointer().getFirst(game, source), game)) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)creature, game));
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent != null) {
                int unboostCount = -1 * new CountersSourceCount(CounterType.P1P1).calculate(game, source, (Effect)this);
                permanent.addPower(unboostCount);
                permanent.addToughness(unboostCount);
                continue;
            }
            it.remove();
        }
        return true;
    }
}

