/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

enum ZombiesControlledByTargetPlayerCount implements DynamicValue
{
    instance;

    private static final FilterPermanent filter;

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player player = game.getPlayer(((Target)sourceAbility.getTargets().get(0)).getFirstTarget());
        if (player != null) {
            int value = game.getBattlefield().countAll(filter, player.getId(), game);
            return -1 * value;
        }
        return 0;
    }

    public ZombiesControlledByTargetPlayerCount copy() {
        return instance;
    }

    public String toString() {
        return "-1";
    }

    public String getMessage() {
        return "Zombie that player controls";
    }

    public int getSign() {
        return -1;
    }

    static {
        filter = new FilterPermanent(SubType.ZOMBIE, "Zombie");
    }
}

