/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.SpaceflightAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CanBlockOnlySpaceflightEffect
extends RestrictionEffect {
    CanBlockOnlySpaceflightEffect(Duration duration) {
        super(duration);
        this.staticText = "{this} can block only creatures with spaceflight";
    }

    private CanBlockOnlySpaceflightEffect(CanBlockOnlySpaceflightEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        return attacker.getAbilities().contains((Ability)SpaceflightAbility.getInstance());
    }

    public CanBlockOnlySpaceflightEffect copy() {
        return new CanBlockOnlySpaceflightEffect(this);
    }
}

