/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class EagerConstructEffect
extends OneShotEffect {
    EagerConstructEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may scry 1";
    }

    private EagerConstructEffect(EagerConstructEffect effect) {
        super((OneShotEffect)effect);
    }

    public EagerConstructEffect copy() {
        return new EagerConstructEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.chooseUse(this.outcome, "Scry 1? <i>(Look at the top card of your library. You may put that card on the bottom of your library.)</i>", source, game)) continue;
                player.scry(1, source, game);
            }
            return true;
        }
        return false;
    }
}

