/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.costs.common.TapAttachedCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterBlockingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledPermanent;

public final class Earthlore
extends CardImpl {
    private static final FilterPermanent filterUntapped = new FilterPermanent("enchanted land is untapped");
    private static final Condition condition;

    public Earthlore(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{G}");
        this.subtype.add((Object)SubType.AURA);
        TargetControlledPermanent auraTarget = new TargetControlledPermanent(StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.AddAbility));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        ActivateIfConditionActivatedAbility ability = new ActivateIfConditionActivatedAbility((Effect)new BoostTargetEffect(1, 2), new TapAttachedCost().setText("Tap enchanted land"), condition);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)new FilterBlockingCreature("blocking creature")));
        this.addAbility((Ability)ability);
    }

    private Earthlore(Earthlore card) {
        super((CardImpl)card);
    }

    public Earthlore copy() {
        return new Earthlore(this);
    }

    static {
        filterUntapped.add((Predicate)TappedPredicate.UNTAPPED);
        condition = new AttachedToMatchesFilterCondition(filterUntapped);
    }
}

