/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EaterOfTheDeadEffect
extends OneShotEffect {
    EaterOfTheDeadEffect() {
        super(Outcome.Exile);
        this.staticText = "If {this} is tapped, exile target creature card from a graveyard and untap {this}";
    }

    private EaterOfTheDeadEffect(EaterOfTheDeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null || !permanent.isTapped()) {
            return false;
        }
        Card card = game.getCard(source.getFirstTarget());
        if (card != null) {
            player.moveCards(card, Zone.EXILED, source, game);
        }
        permanent.untap(game);
        return true;
    }

    public EaterOfTheDeadEffect copy() {
        return new EaterOfTheDeadEffect(this);
    }
}

