/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class EaterOfVirtueExileEffect
extends OneShotEffect {
    EaterOfVirtueExileEffect() {
        super(Outcome.Neutral);
        this.staticText = "exile it";
    }

    private EaterOfVirtueExileEffect(EaterOfVirtueExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public EaterOfVirtueExileEffect copy() {
        return new EaterOfVirtueExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent eaterOfVirtue = game.getPermanent(source.getSourceId());
        Card exiledCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && eaterOfVirtue != null && exiledCard != null) {
            UUID exileId = CardUtil.getExileZoneId((String)(source.getSourceId().toString() + "cards exiled by Eater of Virtue"), (Game)game);
            controller.moveCardsToExile(exiledCard, source, game, true, exileId, eaterOfVirtue.getIdName());
            return true;
        }
        return false;
    }
}

