/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class EccentricFarmerEffect
extends OneShotEffect {
    EccentricFarmerEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill three cards, then you may return a land card from your graveyard to your hand";
    }

    private EccentricFarmerEffect(EccentricFarmerEffect effect) {
        super((OneShotEffect)effect);
    }

    public EccentricFarmerEffect copy() {
        return new EccentricFarmerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(3, source, game);
        if (player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) < 1) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND, true);
        player.choose(this.outcome, (Target)target, source, game);
        player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
        return true;
    }
}

