/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EchoChamberCreateTokenEffect
extends OneShotEffect {
    EchoChamberCreateTokenEffect() {
        super(Outcome.Copy);
        this.staticText = "An opponent chooses target creature they control. Create a token that's a copy of that creature. That token gains haste until end of turn. Exile the token at the beginning of the next end step";
    }

    private EchoChamberCreateTokenEffect(EchoChamberCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoChamberCreateTokenEffect copy() {
        return new EchoChamberCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenCopyTargetEffect effect;
        Permanent copiedPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (copiedPermanent != null && (effect = new CreateTokenCopyTargetEffect(null, CardType.CREATURE, true)).apply(game, source)) {
            for (Permanent copyPermanent : effect.getAddedPermanents()) {
                ExileTargetEffect exileEffect = new ExileTargetEffect();
                exileEffect.setTargetPointer((TargetPointer)new FixedTarget(copyPermanent, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }
}

