/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class EchoesOfEternityEffect
extends ReplacementEffectImpl {
    EchoesOfEternityEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a triggered ability of a colorless spell you control or another colorless permanent you control triggers, that ability triggers an additional time";
    }

    private EchoesOfEternityEffect(EchoesOfEternityEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public EchoesOfEternityEffect copy() {
        return new EchoesOfEternityEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent != null && permanent.getColor(game).isColorless() && !permanent.getId().equals(source.getSourceId())) {
            return true;
        }
        Spell spell = game.getSpell(event.getSourceId());
        return spell != null && spell.getColor(game).isColorless();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

