/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class EchoingCalmEffect
extends OneShotEffect {
    EchoingCalmEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target enchantment and all other enchantments with the same name as that enchantment";
    }

    private EchoingCalmEffect(EchoingCalmEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoingCalmEffect copy() {
        return new EchoingCalmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent != null) {
            permanent.destroy(source, game, false);
            if (!CardUtil.haveEmptyName((MageObject)permanent)) {
                for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
                    if (perm.getId().equals(permanent.getId()) || !CardUtil.haveSameNames((MageObject)perm, (MageObject)permanent) || !perm.isEnchantment(game)) continue;
                    perm.destroy(source, game, false);
                }
            }
            return true;
        }
        return false;
    }
}

