/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class EcstaticBeautyEffect
extends OneShotEffect {
    EcstaticBeautyEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top three cards of your library. You may play those cards until end of turn. Put four time counters on each of those cards that has suspend";
    }

    private EcstaticBeautyEffect(EcstaticBeautyEffect effect) {
        super((OneShotEffect)effect);
    }

    public EcstaticBeautyEffect copy() {
        return new EcstaticBeautyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
            if (!card.getAbilities(game).containsClass(SuspendAbility.class)) continue;
            card.addCounters(CounterType.TIME.createInstance(4), source, game);
        }
        return true;
    }
}

