/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.e.EdgarKingOfFigaroWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.FlipCoinsEvent;
import mage.game.events.GameEvent;

class EdgarKingOfFigaroEffect
extends ReplacementEffectImpl {
    EdgarKingOfFigaroEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "the first time you flip one or more coins each turn, those coins come up heads and you win those flips";
    }

    private EdgarKingOfFigaroEffect(EdgarKingOfFigaroEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((FlipCoinsEvent)event).setHeadsAndWon(true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.FLIP_COINS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId()) && !EdgarKingOfFigaroWatcher.checkPlayer(game, source);
    }

    public EdgarKingOfFigaroEffect copy() {
        return new EdgarKingOfFigaroEffect(this);
    }
}

