/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EdificeOfAuthorityEffect
extends RestrictionEffect {
    EdificeOfAuthorityEffect() {
        super(Duration.UntilYourNextTurn);
        this.staticText = "until your next turn, target creature can't attack or block and its activated abilities can't be activated";
    }

    private EdificeOfAuthorityEffect(EdificeOfAuthorityEffect effect) {
        super((RestrictionEffect)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.addInfo("Can't attack or block and its activated abilities can't be activated." + this.getId(), "", game);
        }
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(permanent.getId());
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public EdificeOfAuthorityEffect copy() {
        return new EdificeOfAuthorityEffect(this);
    }
}

