/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SamuraiToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class EiganjoUprisingEffect
extends OneShotEffect {
    EiganjoUprisingEffect() {
        super(Outcome.Benefit);
        this.staticText = "create X 2/2 white Samurai creature tokens with vigilance. They gain menace and haste until end of turn.<br>Each opponent creates X minus one 2/2 white Samurai creature tokens with vigilance";
    }

    private EiganjoUprisingEffect(EiganjoUprisingEffect effect) {
        super((OneShotEffect)effect);
    }

    public EiganjoUprisingEffect copy() {
        return new EiganjoUprisingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (amount < 1) {
            return false;
        }
        SamuraiToken token = new SamuraiToken();
        token.putOntoBattlefield(amount, game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)new MenaceAbility(false)).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        if (amount < 2) {
            return true;
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            token.putOntoBattlefield(amount - 1, game, source, opponentId);
        }
        return true;
    }
}

