/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.ElectropotenceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ElectropotenceTriggeredAbility
extends TriggeredAbilityImpl {
    public ElectropotenceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ElectropotenceEffect());
    }

    private ElectropotenceTriggeredAbility(ElectropotenceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.controllerId)) {
            ((Effect)this.getEffects().get(0)).setValue("damageSource", (Object)event.getTargetId());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control enters, you may pay {2}{R}. If you do, that creature deals damage equal to its power to any target.";
    }

    public ElectropotenceTriggeredAbility copy() {
        return new ElectropotenceTriggeredAbility(this);
    }
}

