/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.cards.e.ElminsterWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class ElminsterReductionEffect
extends CostModificationEffectImpl {
    private int spellsCast;

    ElminsterReductionEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the next instant or sorcery spell you cast this turn costs {X} less to cast, where X is the number of cards looked at while scrying this way";
    }

    private ElminsterReductionEffect(ElminsterReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        ElminsterWatcher watcher = (ElminsterWatcher)game.getState().getWatcher(ElminsterWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getCount(source.getControllerId());
        }
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)((Integer)this.getValue("amount")));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        ElminsterWatcher watcher = (ElminsterWatcher)game.getState().getWatcher(ElminsterWatcher.class);
        if (watcher == null) {
            return false;
        }
        if (watcher.getCount(source.getControllerId()) > this.spellsCast) {
            this.discard();
            return false;
        }
        if (!(abilityToModify instanceof SpellAbility) || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        return spellCard != null && spellCard.isInstantOrSorcery(game);
    }

    public ElminsterReductionEffect copy() {
        return new ElminsterReductionEffect(this);
    }
}

