/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ElvishHealerEffect
extends OneShotEffect {
    ElvishHealerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Prevent the next 1 damage that would be dealt to any target this turn. If it's a green creature, prevent the next 2 damage instead.";
    }

    private ElvishHealerEffect(ElvishHealerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElvishHealerEffect copy() {
        return new ElvishHealerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int toPrevent = 1;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.isCreature(game) && permanent.getColor(game).isGreen()) {
            toPrevent = 2;
        }
        game.addEffect(new PreventDamageToTargetEffect(Duration.EndOfTurn, toPrevent).setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game)), source);
        return true;
    }
}

